/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.util;

import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import xfacthd.buddingcrystals.common.BCContent;

public final class CommonConfig {
    public static final ForgeConfigSpec SPEC;
    public static final CommonConfig INSTANCE;
    private static final Object2BooleanMap<String> crystalEnabled;
    private final Map<String, ForgeConfigSpec.BooleanValue> crystalEnabledValues = new HashMap<String, ForgeConfigSpec.BooleanValue>();

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        builder.push("crystals");
        Streams.concat((Stream[])new Stream[]{Stream.of(BCContent.AMETHYST), BCContent.builtinSets().stream()}).forEach(set -> {
            ForgeConfigSpec.BooleanValue config = builder.comment("Allow crafting of budding " + set.getTranslation() + " block").translation(set.getConfigTranslation()).define(set.getConfigString(), true);
            this.crystalEnabledValues.put(set.getConfigString(), config);
        });
        builder.pop();
    }

    public static boolean isEnabled(String config) {
        return crystalEnabled.getBoolean((Object)config);
    }

    @SubscribeEvent
    public void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON && event.getConfig().getModId().equals("buddingcrystals")) {
            for (String config : this.crystalEnabledValues.keySet()) {
                crystalEnabled.put((Object)config, ((Boolean)this.crystalEnabledValues.get(config).get()).booleanValue());
            }
        }
    }

    static {
        crystalEnabled = new Object2BooleanArrayMap();
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        SPEC = (ForgeConfigSpec)configSpecPair.getRight();
        INSTANCE = (CommonConfig)configSpecPair.getLeft();
    }
}

